<?php
/**
 * Veidotājs: Roberts Blite
 * Mērķis: Šis PHP skripts pārvalda FAQ sadaļas datubāzes operācijas - pievienošanu, lasīšanu,
 *         atjaunināšanu un dzēšanu.
 * Apraksts: Skripts saņem AJAX pieprasījumus no klienta puses, apstrādā tos un veic nepieciešamās
 *           darbības ar MySQL datubāzi, atgriežot rezultātus JSON formātā.
 */

// Datubāzes pieslēguma iestatījumi
$servername = "database-1.cd0m46mqkm83.eu-north-1.rds.amazonaws.com";
$username = "admin";
$password = "HyperX3146!";
$dbname = "rb_kvalif_410";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die(json_encode(["error" => "Neizdevās izveidot savienojumu ar datubāzi: " . $conn->connect_error]));
}

// Iestata JSON atbildes tipu
header('Content-Type: application/json');

// Iegūst darbību no GET pieprasījuma
$action = $_GET['action'] ?? '';

switch ($action) {
    // Pievienot jaunu ierakstu FAQ tabulā
    case 'create':
        $data = json_decode(file_get_contents('php://input'), true);

        // Pārbauda, vai ir saņemti nepieciešamie lauki
        if (!isset($data['question'], $data['answer'])) {
            echo json_encode(["error" => "Nepareizi ievaddati."]);
            exit;
        }

        // Sanitizē ievades datus, lai novērstu SQL injekcijas
        $question = $conn->real_escape_string($data['question']);
        $answer = $conn->real_escape_string($data['answer']);

        // Sagatavo SQL vaicājumu ieraksta pievienošanai
        $stmt = $conn->prepare("INSERT INTO rb_kvalif_faq_410 (question, answer) VALUES (?, ?)");
        $stmt->bind_param("ss", $question, $answer);

        // Izpilda vaicājumu un pārbauda rezultātu
        if (!$stmt->execute()) {
            echo json_encode(["error" => $stmt->error]);
            exit;
        }

        echo json_encode(["success" => true]);
        break;

    // Iegūt visus ierakstus no FAQ tabulas
    case 'read':
        $result = $conn->query("SELECT * FROM rb_kvalif_faq_410");

        // Pārbauda, vai vaicājums izdevies
        if (!$result) {
            echo json_encode(["error" => $conn->error]);
            exit;
        }

        // Sagatavo datus JSON atgriešanai
        $faqs = $result->fetch_all(MYSQLI_ASSOC);
        echo json_encode($faqs);
        break;

    // Atjaunināt esošu FAQ ierakstu
    case 'update':
        $data = json_decode(file_get_contents('php://input'), true);

        // Pārbauda, vai ir saņemti nepieciešamie lauki
        if (!isset($data['id'], $data['question'], $data['answer'])) {
            echo json_encode(["error" => "Nepareizi ievaddati."]);
            exit;
        }

        $id = intval($data['id']);
        $question = $conn->real_escape_string($data['question']);
        $answer = $conn->real_escape_string($data['answer']);

        // Sagatavo SQL vaicājumu ieraksta atjaunināšanai
        $stmt = $conn->prepare("UPDATE rb_kvalif_faq_410 SET question = ?, answer = ? WHERE id = ?");
        $stmt->bind_param("ssi", $question, $answer, $id);

        // Izpilda vaicājumu un pārbauda rezultātu
        if (!$stmt->execute()) {
            echo json_encode(["error" => $stmt->error]);
            exit;
        }

        echo json_encode(["success" => true]);
        break;

    // Dzēst FAQ ierakstu pēc ID
    case 'delete':
        $id = intval($_GET['id']); // Konvertē ID uz skaitli, lai izvairītos no SQL injekcijas

        if (!$id) {
            echo json_encode(["error" => "Nepareizs ID."]);
            exit;
        }

        // Sagatavo SQL vaicājumu ieraksta dzēšanai
        $stmt = $conn->prepare("DELETE FROM rb_kvalif_faq_410 WHERE id = ?");
        $stmt->bind_param("i", $id);

        // Izpilda vaicājumu un pārbauda rezultātu
        if (!$stmt->execute()) {
            echo json_encode(["error" => $stmt->error]);
            exit;
        }

        echo json_encode(["success" => true]);
        break;

    // Noklusējuma gadījums, ja darbība nav norādīta vai ir nederīga
    default:
        echo json_encode(["error" => "Nepareiza darbība."]);
}

// Aizver savienojumu ar datubāzi
$conn->close();
?>
